unit clsUserDetailsCollection;

interface

uses
  clsUserDetails, System.Collections, System.ComponentModel;

type

  TUserDetailsCollection = class(CollectionBase)
  private
    function GetItem(index : Integer) : TUser; virtual;
  public
    property Item[index : Integer] : TUser read GetItem; default;
    function Add(Value : TUser) : Integer;
    procedure Insert(index : integer ; Value : TUser);
    function IndexOf(Value : TUser) : Integer;
    procedure Remove(Value : TUser);
    function Contains(Value : TUser) : Boolean;
  end;

implementation

{ TUserDetailsCollection }

function TUserDetailsCollection.Add(Value: TUser): Integer;
begin
  Result := List.Add(Value);
end;

function TUserDetailsCollection.Contains(Value: TUser): Boolean;
begin
  Result := List.Contains(Value);
end;

function TUserDetailsCollection.GetItem(index: Integer): TUser;
begin
  Result := TUser(List[index]);
end;

function TUserDetailsCollection.IndexOf(Value: TUser): Integer;
begin
  Result := List.IndexOf(Value);
end;

procedure TUserDetailsCollection.Insert(index: integer; Value: TUser);
begin
  List.Insert(index,Value);
end;

procedure TUserDetailsCollection.Remove(Value: TUser);
begin
  List.Remove(Value);
end;


end.
